#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import datetime
import os
import re
import shutil
import time
import os.path

import chdb
import configreader
import status
import ts2x264
import tv2ts
import recdblist
import tv2audio


global Bitrate_SD
global Bitrate_HD
global Bitrate_FHD
global Bitrate_Short
global Bitrate_LowHD
Bitrate_SD = 1250
Bitrate_HD = 3750
Bitrate_LowHD = 2500
Bitrate_FHD = 5000
Bitrate_Short = 1250
def timetv2b25(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル
    """
    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tnow = datetime.datetime.now()
    wt = bt-tnow
    waitt = wt.seconds-5
    time.sleep(waitt)
    tnow = datetime.datetime.now()
    dt = et-tnow
    rectime = dt.seconds-10
    rectime = str(rectime)
    tv2ts.tv2b25ts(tsout + ".ts.b25", chdb.chtxtsearch(chtxt)['ch'], rectime)
def b252ts(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル(自動的にtitle.b25 title.tsと名前がつきます。)
    """
    #status.setB25Decoding(status.getB25Decoding() + 1)
    status.changeB25Decoding(1)
    try:
        tv2ts.b252ts(pout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'])
        tsout = pout
        aviin = pout + ".ts"
        dualaudio = 0
        pentaaudio = 0
        if re.search("5", opt):
            pentaaudio = 1
        if re.search("d", opt):
            dualaudio = 1
        if re.search(u"\[二\]", pout):
            dualaudio = 1
        elif re.search(u'（二）', pout):
            dualaudio = 1
        elif re.search(u'\(二\)', pout):
            dualaudio = 1
        if dualaudio == 1:
            dualaudio2sep(aviin,"167")
        if pentaaudio == 1:
            pentaaudio2sep(aviin)
    except Exception, inst:
        print "Error happened in b252ts in tv2avi"
        print str(type(inst))
        print str(inst)
    status.changeB25Decoding(-1)
def ts2avi(pin, pout, opt):
    status.changeEncoding(1)
    try:
        ts2x264.ts2x264(pin, pout, opt)
    except Exception, inst:
        print "error occures in tv2avi.py ts2avi"
        print type(inst)
        print inst
    status.changeEncoding(-1)
def dualaudiots2avi(pin, pout):
    bontsdemux = configreader.getpath('bontsdemux')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    xvfb = configreader.getpath('xvfb-run')
    logpath=pin.replace("ts","log")
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 0 -o \"" + bonpout + "\" -start -quit"
    #recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    os.system(exe.encode('utf-8'))
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    exe = "ffmpeg -y  -i \'" + ffpin1 + "\' -i \'" + ffpin2 + "\' -r 29.97 -vsync 200 -vcodec copy -acodec libmp3lame -async 200 -ab 128k -f avi  \'" + pout + "\'"
    recdblist.printutf8(exe)
    #commands.getoutput(exe)
    os.system(exe.encode('utf-8'))
    os.remove(ffpin1)
    os.remove(ffpin2)
def dualaudio2sep(pin, delay):
    """
    delay is string
    """
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    xvfb = configreader.getpath('xvfb-run')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 1 -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addlog(pin, txt, "dualaudio-sep1 BontsDemux")
    except:
        ""
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "_1.wav"
    ffpout2 = ffpin + "_2.wav"
    ffpout3 = ffpin + ".m2v"
    shutil.move(ffpin1, ffpout1)
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 2 -encode Demux\(wav\) -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addlog(pin, txt, "dualaudio-sep1 BontsDemux")
    except:
        ""
    #os.system(exe)
    shutil.move(ffpin1, ffpout2)
    shutil.move(ffpin2, ffpout3)
    ffpout21=ffpout1.replace(".wav",".mp3")
    ffpout22=ffpout2.replace(".wav",".mp3")
    useNero=0
    try:
        if configreader.getpath("useNeroAAC")=="1" and os.path.exists(configreader.getpath("NeroAAC")):
            useNero=1
    except:
        useNero=0
    if useNero==1:
        ffpout21=ffpout1.replace(".wav",".aac")
        ffpout22=ffpout2.replace(".wav",".aac")
        tv2audio.wav2aac_nero(ffpout1, ffpout21)
        tv2audio.wav2aac_nero(ffpout2, ffpout22)
    else:
        tv2audio.wav2mp3_lame(ffpout1, ffpout21)
        tv2audio.wav2mp3_lame(ffpout2, ffpout22)
    time.sleep(3)
    os.remove(ffpout1)
    os.remove(ffpout2)
def pentaaudio2sep(pin):
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    xvfb = configreader.getpath('xvfb-run')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 3 -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addlog(pin, txt, "pentaaudio-sep1 BontsDemux")
    except:
        ""
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "_1.wav"
    ffpout2 = ffpin + "_2.aac"
    shutil.move(ffpin1, ffpout1)
    exe = "ffmpeg -i '"+pin+"' -vn -f aac -acodec copy '"+ffpout2+"'"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addlog(pin, txt, "pentaaudio-sep2(raw aac) ffmpeg")
    except:
        ""
    ffpout21=ffpout1.replace(".wav",".mp3")
    useNero=0
    try:
        if configreader.getpath("useNeroAAC")=="1" and os.path.exists(configreader.getpath("NeroAAC")):
            useNero=1
    except:
        useNero=0
    if useNero==1:
        ffpout21=ffpout1.replace(".wav",".aac")
        tv2audio.wav2aac_nero(ffpout1, ffpout21)
    else:
        tv2audio.wav2mp3_lame(ffpout1, ffpout21)
    if not os.path.exists(ffpout21):
        exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 0 -o \"" + bonpout + "\" -start -quit"
        exe = xvfb + ' -a ' + exe
        recdblist.printutf8(exe)
        txt=commands.getoutput(exe.encode('utf-8'))
        try:
            recdblist.addlog(pin, txt, "pentaaudio-sep Downmix (5.1ch error) BontsDemux")
        except:
            ""
        shutil.move(ffpin1, ffpout1)
        if useNero==1:
            ffpout21=ffpout1.replace(".wav",".aac")
            tv2audio.wav2aac_nero(ffpout1, ffpout21)
        else:
            tv2audio.wav2mp3_lame(ffpout1, ffpout21)
        time.sleep(3)
    if os.path.exists(ffoput21):
        if os.path.getsize(ffpout21)>10*1000*1000:
            os.remove(ffpout1)
def pentaaudiots2avi(pin, pout):
    bontsdemux = configreader.getpath('bontsdemux')
    bonpin = "Z:\\" + pin[1:]
    xvfb = configreader.getpath('xvfb-run')
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 3 -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=u"Cmd : "+exe+"\n"
    txt=txt+commands.getoutput(exe.encode('utf-8'))
    recdblist.addlog(pin, txt, "5.1ch audio Demux log")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")


    exe = u"ffmpeg -y  -i \"" + ffpin1 + u"\" -i \'" + ffpin2 + u"\' -r 29.97 -vsync 200 -vcodec copy -acodec libmp3lame -async 200 -ab 128k -f avi  \"" + pout + "\""
    recdblist.printutf8(exe)
    txt=u"Cmd : "+exe+"\n"
    txtt=commands.getoutput(exe.encode('utf-8'))
    try:
        txt=txt+txtt
    except:
        txt=txt+"skip logging (not UTF-8)"
    recdblist.addlog(pin, txt, "5.1ch audio Mux log")
    if os.path.exists(pout):
        if os.path.getsize(pout)>100*1000:
            os.remove(ffpin1)
            os.remove(ffpin2)

